---
title: GraphQL datasets · Cloudflare Data Localization Suite docs
description: The table below shows a non-exhaustive list of GraphQL Analytics
  API fields that respect CMB configuration and are available in both the US and
  the EU or only in the US.
lastUpdated: 2025-09-17T14:35:09.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/data-localization/metadata-boundary/graphql-datasets/
  md: https://developers.cloudflare.com/data-localization/metadata-boundary/graphql-datasets/index.md
---

The table below shows a non-exhaustive list of GraphQL Analytics API fields that respect CMB configuration and are available in both the US and the EU or only in the US.

| Suite/Category | Product | GraphQL Analytics API Field(s) supported in |
| - | - | - |
| Application Performance | Caching/CDN | US and EU `httpRequestsAdaptive` `httpRequestsAdaptiveGroups` `httpRequestsOverviewAdaptiveGroups` US only `httpRequests1mGroups` `httpRequests1hGroups` `httpRequests1dGroups` |
| Cache Reserve | | US and EU `cacheReserveOperationsAdaptiveGroups` `cacheReserveRequestsAdaptiveGroups` `cacheReserveStorageAdaptiveGroups` |
| DNS | | US only `dnsAnalyticsAdaptive` `dnsAnalyticsAdaptiveGroups` |
| Image Resizing | | US only `imageResizingRequests1mGroups` `imagesRequestsAdaptiveGroups` `imagesUniqueTransformations` |
| Load Balancing | | US only [`loadBalancingRequestsAdaptive`](https://developers.cloudflare.com/load-balancing/reference/load-balancing-analytics/#graphql-analytics) [`loadBalancingRequestsAdaptiveGroups`](https://developers.cloudflare.com/load-balancing/reference/load-balancing-analytics/#graphql-analytics) `healthCheckEventsAdaptive` `healthCheckEventsAdaptiveGroups` |
| Stream Delivery | Same as Caching/CDN | |
| Tiered Caching | | US and EU Only the field `upperTierColoName` part of `httpRequestsAdaptive` and `httpRequestsAdaptiveGroups` |
| Secondary DNS | Same as DNS | |
| Waiting Room | | US and EU [`waitingRoomAnalyticsAdaptive`](https://developers.cloudflare.com/waiting-room/waiting-room-analytics/#graphql-analytics) [`waitingRoomAnalyticsAdaptiveGroups`](https://developers.cloudflare.com/waiting-room/waiting-room-analytics/#graphql-analytics) |
| Web Analytics / Real User Monitoring (RUM) | | US only `rumWebVitalsEventsAdaptive` `rumWebVitalsEventsAdaptiveGroups` `rumPerformanceEventsAdaptiveGroups` `rumPageloadEventsAdaptiveGroups` |
| Zaraz | | US and EU `zarazActionsAdaptiveGroups` `zarazTrackAdaptiveGroups` `zarazTriggersAdaptiveGroups` |
| Application Security | Advanced Certificate Manager | US and EU Only the fields `clientSSLProtocol` and `ja3Hash` part of `httpRequestsAdaptive` and `httpRequestsAdaptiveGroups` |
| Advanced DDoS Protection | | US and EU [`dosdAttackAnalyticsGroups`](https://developers.cloudflare.com/analytics/graphql-api/migration-guides/network-analytics-v2/node-reference/) [`dosdNetworkAnalyticsAdaptiveGroups`](https://developers.cloudflare.com/analytics/graphql-api/migration-guides/network-analytics-v2/node-reference/) [`flowtrackdNetworkAnalyticsAdaptiveGroups`](https://developers.cloudflare.com/analytics/graphql-api/migration-guides/network-analytics-v2/node-reference/) `advancedTcpProtectionNetworkAnalyticsAdaptiveGroups` `advancedDnsProtectionNetworkAnalyticsAdaptiveGroups` |
| API Shield | | US and EU [`apiGatewayGraphqlQueryAnalyticsGroups`](https://developers.cloudflare.com/api-shield/security/graphql-protection/api/#gather-graphql-statistics) `apiGatewayMatchedSessionIDsAdaptiveGroups` US only `apiRequestSequencesGroups` |
| Bot Management | | US and EU `httpRequestsAdaptive` [`httpRequestsAdaptiveGroups`](https://developers.cloudflare.com/analytics/graphql-api/migration-guides/graphql-api-analytics/) [`firewallEventsAdaptive`](https://developers.cloudflare.com/analytics/graphql-api/tutorials/querying-firewall-events/) [`firewallEventsAdaptiveGroups`](https://blog.cloudflare.com/how-we-used-our-new-graphql-api-to-build-firewall-analytics/) |
| DNS Firewall | Same as DNS | |
| DMARC Management | | US and EU `dmarcReportsAdaptive` `dmarcReportsSourcesAdaptiveGroups` |
| Page Shield | | US and EU [`pageShieldReportsAdaptiveGroups`](https://developers.cloudflare.com/page-shield/policies/violations/#get-policy-violations-via-graphql-api) |
| SSL | | US and EU Only the fields `clientSSLProtocol` and `ja3Hash` part of `httpRequestsAdaptive` and `httpRequestsAdaptiveGroups` |
| SSL 4 SaaS | | US and EU [clientRequestHTTPHost](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/hostname-analytics/#explore-customer-usage) Refer to [GraphQL Tutorial on querying HTTP events by hostname](https://developers.cloudflare.com/analytics/graphql-api/tutorials/end-customer-analytics/) |
| Turnstile | | US and EU [`turnstileAdaptiveGroups`](https://developers.cloudflare.com/turnstile/turnstile-analytics/#graphql) |
| WAF/L7 Firewall | | US and EU [`firewallEventsAdaptive`](https://developers.cloudflare.com/analytics/graphql-api/tutorials/querying-firewall-events/) [`firewallEventsAdaptiveGroups`](https://blog.cloudflare.com/how-we-used-our-new-graphql-api-to-build-firewall-analytics/) `firewallEventsAdaptiveByTimeGroups` |
| Developer Platform | Cloudflare Images | US only `imagesRequestsAdaptiveGroups` |
| Cloudflare Pages | | US only `pagesFunctionsInvocationsAdaptiveGroups`  |
| Durable Objects | | US only [`durableObjectsInvocationsAdaptiveGroups`](https://developers.cloudflare.com/durable-objects/observability/metrics-and-analytics/) [`durableObjectsPeriodicGroups`](https://developers.cloudflare.com/durable-objects/observability/metrics-and-analytics/) [`durableObjectsStorageGroups`](https://developers.cloudflare.com/durable-objects/observability/metrics-and-analytics/) [`durableObjectsSubrequestsAdaptiveGroups`](https://developers.cloudflare.com/durable-objects/observability/metrics-and-analytics/) |
| Email Routing | | US and EU `emailRoutingAdaptive` `emailRoutingAdaptiveGroups` |
| R2 | | US and EU `r2OperationsAdaptiveGroups` `r2StorageAdaptiveGroups` |
| Stream | | US only [`streamMinutesViewedAdaptiveGroups`](https://developers.cloudflare.com/stream/getting-analytics/fetching-bulk-analytics/) [`videoPlaybackEventsAdaptiveGroups`](https://developers.cloudflare.com/stream/getting-analytics/fetching-bulk-analytics/) [`videoBufferEventsAdaptiveGroups`](https://developers.cloudflare.com/stream/getting-analytics/fetching-bulk-analytics/) [`videoQualityEventsAdaptiveGroups`](https://developers.cloudflare.com/stream/getting-analytics/fetching-bulk-analytics/) |
| Workers (deployed on a Zone) | | US and EU `workerPlacementAdaptiveGroups` US only `workersAnalyticsEngineAdaptiveGroups` `workersZoneInvocationsAdaptiveGroups` `workersZoneSubrequestsAdaptiveGroups` `workersOverviewRequestsAdaptiveGroups` `workersOverviewDataAdaptiveGroups` [`workersInvocationsAdaptive`](https://developers.cloudflare.com/analytics/graphql-api/tutorials/querying-workers-metrics/) `workersInvocationsScheduled` `workersSubrequestsAdaptiveGroups` |
| Network Services | Network Error Logging (NEL) / Edge Reachability / Last Mile Insights | US only `nelReportsAdaptiveGroups` |
| Magic Firewall | | US only [`magicFirewallSamplesAdaptiveGroups`](https://developers.cloudflare.com/magic-firewall/tutorials/graphql-analytics/) [`magicFirewallNetworkAnalyticsAdaptiveGroups`](https://developers.cloudflare.com/magic-firewall/tutorials/graphql-analytics/#example-queries-for-magic-firewall) |
| Magic Network Monitoring | | US only [`mnmFlowDataAdaptiveGroups`](https://developers.cloudflare.com/magic-network-monitoring/tutorials/graphql-analytics/) |
| Magic Transit | | US and EU [`magicTransitNetworkAnalyticsAdaptiveGroups`](https://developers.cloudflare.com/analytics/graphql-api/migration-guides/network-analytics-v2/node-reference/) [`flowtrackdNetworkAnalyticsAdaptiveGroups`](https://developers.cloudflare.com/analytics/graphql-api/migration-guides/network-analytics-v2/node-reference/) `magicTransitTunnelHealthCheckSLOsAdaptiveGroups` [`magicTransitTunnelHealthChecksAdaptiveGroups`](https://developers.cloudflare.com/analytics/graphql-api/tutorials/querying-magic-transit-tunnel-healthcheck-results/) [`magicTransitTunnelTrafficAdaptiveGroups`](https://developers.cloudflare.com/magic-transit/analytics/query-bandwidth/) |
| Magic WAN | | US only `MagicWANConnectorMetricsAdaptiveGroups` |
| Spectrum | | US and EU [`spectrumNetworkAnalyticsAdaptiveGroups`](https://developers.cloudflare.com/analytics/graphql-api/migration-guides/network-analytics-v2/node-reference/) |
| Platform | GraphQL Analytics API | US and EU [All GraphQL Analytics API datasets](https://developers.cloudflare.com/analytics/graphql-api/features/discovery/introspection/) |
| Logpush | | US only [`logpushHealthAdaptiveGroups`](https://developers.cloudflare.com/logs/logpush/alerts-and-analytics/#enable-logpush-health-analytics)  |
| Zero Trust | Access | US and EU [`accessLoginRequestsAdaptiveGroups`](https://developers.cloudflare.com/analytics/graphql-api/tutorials/querying-access-login-events/) |
| Browser Isolation | | US and EU Only the field `isIsolated` part of `gatewayL7RequestsAdaptiveGroups` |
| DLP | Part of Gateway HTTP / Gateway L7 | |
| Gateway | | US and EU `gatewayL7RequestsAdaptiveGroups` `gatewayL4SessionsAdaptiveGroups` `gatewayResolverQueriesAdaptiveGroups` `gatewayResolverByCategoryAdaptiveGroups` `gatewayResolverByRuleExecutionPerformanceAdaptiveGroups` US only `gatewayL4DownstreamSessionsAdaptiveGroups` `gatewayL4UpstreamSessionsAdaptiveGroups` |
| WARP | | US and EU `warpDeviceAdaptiveGroups` |
