---
title: JumpCloud · Cloudflare One docs
description: Learn how to deploy Cloudflare WARP using JumpCloud.
lastUpdated: 2025-10-21T14:33:19.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/partners/jumpcloud/
  md: https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/partners/jumpcloud/index.md
---

## Windows

1. Log in to the [JumpCloud Admin Portal](https://console.jumpcloud.com).

2. Go to **Device Management** > **Software Management**.

3. Select the **Windows** tab, then select **(+)**.

   ![Configuring WARP in the JumpCloud Windows tab](https://developers.cloudflare.com/_astro/jumpcloud.COKUk56X_1BPpdU.webp)

4. In the **Software Name** field, enter a unique display name.

5. In the **Package ID** field, enter `warp`.

6. Select **Install this software**.

7. (Optional) Select **Keep software package up to date** to automatically update this app as updates become available.

8. (Optional) Select **Allow end users to delay updates for up to one week** to avoid updates during a busy time.

9. Select **save**.

10. Select the device(s) you want to deploy the app to:

    * **Single device**: Go to the **Devices** tab and select the target device.
    * **Device group**: Go to the **Device Groups** tab and select the target device group.

11. Select **save**.

12. Select **save** again.

Verify that Cloudflare WARP was installed by selecting the app and viewing the **Status** tab.

After deploying the WARP client, you can check its connection progress using the [Connectivity status](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/troubleshooting/connectivity-status/) messages displayed in the WARP GUI.

## macOS

1. Log in to the [JumpCloud Admin Portal](https://console.jumpcloud.com).

2. Go to **Device Management** > **Software Management**.

3. Select the **Apple** tab, then select **(+)**.

   ![Configuring WARP in the JumpCloud Apple tab](https://developers.cloudflare.com/_astro/jumpcloud-mac.B_6biy3e_Z258a2F.webp)

4. In the **Software Description** field, enter a unique display name.

5. In the **Software Package URL**, enter the URL location of the `Cloudflare_WARP_<VERSION>.pkg` file. If you do not already have the installer package, [download it here](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/#macos).

6. Select the device(s) you want to deploy the app to:

   * **Single device**: Go to the **Devices** tab and select the target device. To select all devices, select the checkbox next to **Type**.
   * **Device group**: Go to the **Device Groups** tab and select the target device group. To select all device groups, select the checkbox next to **Type**.

7. Select **save** to install the client.

Verify that Cloudflare WARP was installed by selecting the app and viewing the **Status** tab.

After deploying the WARP client, you can check its connection progress using the [Connectivity status](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/troubleshooting/connectivity-status/) messages displayed in the WARP GUI.
