---
title: Manage custom certificates · Cloudflare for Platforms docs
description: Learn how to manage custom certificates for your Cloudflare for
  SaaS custom hostnames.
lastUpdated: 2025-02-07T17:10:08.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/security/certificate-management/custom-certificates/uploading-certificates/
  md: https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/security/certificate-management/custom-certificates/uploading-certificates/index.md
---

Learn how to manage custom certificates for your Cloudflare for SaaS custom hostnames. For use cases and limitations, refer to [custom certificates](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/security/certificate-management/custom-certificates/).

## Upload certificates

This section describes the general process for uploading a custom certificate corresponding to one of the [supported types](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/security/certificate-management/custom-certificates/#limitations).

Note

If you must support both RSA and ECDSA refer to [certificate packs](#use-certificate-packs-rsa-and-ecdsa) below.

* Dashboard

  To upload a custom certificate in the dashboard, select **Custom certificate** while [creating your custom hostname](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/domain-support/create-custom-hostnames/).

  For information about the **bundle method** options, refer to the [Cloudflare SSL/TLS documentation](https://developers.cloudflare.com/ssl/edge-certificates/custom-certificates/bundling-methodologies/).

* API

  The call below will upload a certificate for use with `app.example.com`.

  Note that if you are using an ECC key generated by OpenSSL, you will need to first remove the `-----BEGIN EC PARAMETERS-----...-----END EC PARAMETERS-----` section of the file.

  1. Update the file and build the payload

  ```sh
  cat app_example_com.pem
  ```

  ```sh
  -----BEGIN CERTIFICATE-----
  MIIFJDCCBAygAwIBAgIQD0ifmj/Yi5NP/2gdUySbfzANBgkqhkiG9w0BAQsFADBN
  MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMScwJQYDVQQDEx5E
  ...
  SzSHfXp5lnu/3V08I72q1QNzOCgY1XeL4GKVcj4or6cT6tX6oJH7ePPmfrBfqI/O
  OeH8gMJ+FuwtXYEPa4hBf38M5eU5xWG7
  -----END CERTIFICATE-----
  ```

  ```sh
  MYCERT="$(cat app_example_com.pem|perl -pe 's/\r?\n/\\n/'|sed -e 's/..$//')"
  MYKEY="$(cat app_example_com.key|perl -pe 's/\r?\n/\\n/'|sed -e's/..$//')"
  ```

  With the certificate and key saved to environment variables (using escaped newlines), build the payload:

  ```bash
  $ echo $MYCERT
  -----BEGIN CERTIFICATE-----\nMIIFJDCCBAygAwIBAgIQD0ifmj/Yi5NP/2gdUySbfzANBgkqhkiG9w0BAQsFADBN\nMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMScwJQYDVQQDEx5E...SzSHfXp5lnu/3V08I72q1QNzOCgY1XeL4GKVcj4or6cT6tX6oJH7ePPmfrBfqI/O\nOeH8gMJ+FuwtXYEPa4hBf38M5eU5xWG7\n-----END CERTIFICATE-----\n


  $ request_body=$(< <(cat <<EOF
  {
    "hostname": "app.example.com",
    "ssl": {
      "custom_certificate": "$MYCERT",
      "custom_key": "$MYKEY"
    }
  }
  EOF
  ))
  ```

  1. Use a [`POST` request](https://developers.cloudflare.com/api/resources/custom_hostnames/methods/create/) to upload your certificate and key.

  Note

  The serial number returned is unique to the issuer, but not globally unique. Additionally, it is returned as a string, not an integer.

## Use certificate packs: RSA and ECDSA

A certificate pack allows you to upload up to one RSA and one ECDSA custom certificates to a custom hostname. This process is currently only supported via API.

To upload an RSA and ECDSA certificate to a custom hostname, set the `bundle_method` to `force` and define the `custom_cert_bundle` property when [creating a custom hostname via API](https://developers.cloudflare.com/api/resources/custom_hostnames/methods/create/).

You can also use `"bundle_method": "force"` and `custom_cert_bundle` with a `PATCH` request to the [Edit Custom Hostname](https://developers.cloudflare.com/api/resources/custom_hostnames/methods/edit/) endpoint.

### Delete a custom certificate and private key

Use the [Delete Single Certificate And Key For Custom Hostname](https://developers.cloudflare.com/api/resources/custom_hostnames/subresources/certificate_pack/subresources/certificates/methods/delete/) endpoint to remove one of the custom certificates and corresponding key from a certificate pack.

You cannot delete a certificate if it is the only remaining certificate in the pack.

### Replace a custom certificate and private key

To replace a single custom certificate within a certificate pack that contains two bundled certificates, use the [Replace Custom Certificate And Custom Key In Custom Hostname](https://developers.cloudflare.com/api/resources/custom_hostnames/subresources/certificate_pack/subresources/certificates/methods/update/) endpoint.

You can only replace an RSA certificate with another RSA certificate, or an ECDSA certificate with another ECDSA certificate.

***

## Move to a Cloudflare certificate

If you want to switch from maintaining a custom certificate to using one issued by Cloudflare, you can migrate that certificate with zero downtime.

Send a [`PATCH` request](https://developers.cloudflare.com/api/resources/custom_hostnames/methods/edit/) to your custom hostname with a value for the DCV `method`. As soon as the [certificate is validated](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/security/certificate-management/issue-and-validate/) and the [hostname is validated](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/domain-support/hostname-validation/), Cloudflare will remove the old custom certificate and begin serving the new one.
