---
title: Changelog · Cloudflare Cache (CDN) docs
description: You can now access all Cloudflare cache purge methods — no matter
  which plan you’re on. Whether you need to update a single asset or instantly
  invalidate large portions of your site’s content, you now have the same
  powerful tools previously reserved for Enterprise customers.
lastUpdated: 2025-04-23T17:56:42.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cache/changelog/
  md: https://developers.cloudflare.com/cache/changelog/index.md
---

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/cache.xml)

## 2025-04-03

**All cache purge methods now available for all plans**

You can now access all Cloudflare cache purge methods — no matter which plan you’re on. Whether you need to update a single asset or instantly invalidate large portions of your site’s content, you now have the same powerful tools previously reserved for Enterprise customers.

**Anyone on Cloudflare can now:**

1. [Purge Everything](https://developers.cloudflare.com/cache/how-to/purge-cache/purge-everything/): Clears all cached content associated with a website.
2. [Purge by Prefix](https://developers.cloudflare.com/cache/how-to/purge-cache/purge_by_prefix/): Targets URLs sharing a common prefix.
3. [Purge by Hostname](https://developers.cloudflare.com/cache/how-to/purge-cache/purge-by-hostname/): Invalidates content by specific hostnames.
4. [Purge by URL (single-file purge)](https://developers.cloudflare.com/cache/how-to/purge-cache/purge-by-single-file/): Precisely targets individual URLs.
5. [Purge by Tag](https://developers.cloudflare.com/cache/how-to/purge-cache/purge-by-tags/): Uses Cache-Tag response headers to invalidate grouped assets, offering flexibility for complex cache management scenarios.

Want to learn how each purge method works, when to use them, or what limits apply to your plan? Dive into our [purge cache documentation](https://developers.cloudflare.com/cache/how-to/purge-cache/) and [API reference](https://developers.cloudflare.com/api/resources/cache/methods/purge/) for all the details.

## 2025-02-04

**Fight CSAM More Easily Than Ever**

You can now implement our **child safety tooling**, the **[CSAM Scanning Tool](https://developers.cloudflare.com/cache/reference/csam-scanning/)**, more easily. Instead of requiring external reporting credentials, you only need a verified email address for notifications to onboard. This change makes the tool more accessible to a wider range of customers.

**How It Works**

When enabled, the tool automatically [hashes images for enabled websites as they enter the Cloudflare cache](https://blog.cloudflare.com/the-csam-scanning-tool/). These hashes are then checked against a database of **known abusive images**.

* **Potential match detected?**

  * The **content URL is blocked**, and
  * **Cloudflare will notify you** about the found matches via the provided email address.

**Updated Service-Specific Terms**

We have also made updates to our **[Service-Specific Terms](https://www.cloudflare.com/service-specific-terms-application-services/#csam-scanning-tool-terms)** to reflect these changes.

## 2025-01-08

**Smart Tiered Cache for Load balancing**

Smart Tiered Cache will now select a common single best Upper Tier for an entire Load Balancing Pool based on Origin performance measurements, increasing the cache HIT ratio.

## 2024-11-20

**Smart Tiered Cache for R2**

R2 now automatically gets tiered cache if using Smart Tiered Cache. We select a data center close to your R2 storage bucket as a common Upper Tier cache.

## 2024-11-07

**Shard Cache by cache key**

For custom cache keys, enterprise customers can now shard their cache using up to three values for previously restricted headers `accept*`, `referer`, and `user-agent`. Sharding the cache can improve cache `HIT` ratio and performance. However, overly sharding your cache, can have the opposite effect.

## 2024-11-07

**Versioning**

Cache now supports versioned environments allowing customers to stage configurations and purge staged environments. Note that Cache Reserve is only supported for your production environment.

## 2024-09-05

**New Cache Rules templates for one-click rule creation**

The new **Rules** > **Templates** page in the Cloudflare dashboard provides one-click templates for creating cache rules, making it easy to optimize your caching strategy. Access these pre-built templates directly from each product's rule builder, and explore the [Examples gallery](https://developers.cloudflare.com/rules/examples/) in the developer documentation for real-world use cases.

## 2024-07-19

**Generic tiered cache**

[Generic Global Tiered Cache](https://developers.cloudflare.com/cache/how-to/tiered-cache/#generic-global-tiered-cache) topology leverages all Cloudflare data centers as upper-tier cache network. It now hashes content within a region reducing duplication in upper-tier caches, which increases cache `HIT` ratio.
